/***************************************************************************
 *
 * Copyright (c) 2013 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include <cstdlib>
#include <iostream>
#include <sstream>

#include "InputDeviceConfiguration.h"

using namespace std;
using namespace LayerManagerCalibration;

int main(int argc, char **argv)
{

    if (argc < 4)
    {
        cerr << endl;
        cerr << "Usage: " << argv[0] << " CONFIG_FILE_PATH X_COORDINATE Y_COORDINATE" << endl;
        cerr << endl;
        exit(1);
    }

    InputDeviceConfiguration config;

    if (!config.parseFile(argv[1]))
    {
        cerr << "Failed to parse device configuration file \""
             << argv[1] << "\"" << endl;
        exit(1);
    }

    stringstream ssX(argv[2]);
    uint nrawX, nrawY;

    if ((ssX >> nrawX).fail())
    {
        cerr << "Can't convert value to X coordinate \""
             << argv[2] << "\"" << endl;
        exit(1);
    }

    stringstream ssY(argv[3]);

    if ((ssY >> nrawY).fail())
    {
        cerr << "Can't convert value to Y coordinate \""
             << argv[3] << "\"" << endl;
        exit(1);
    }

    coordinate srawCoordinate;
    coordinate logicalCoordinate;
    srawCoordinate.x = nrawX;
    srawCoordinate.y = nrawY;

    Subdivision *subdivisionEntry;

    if (config.getSubdivisionForCoordinate(srawCoordinate, &subdivisionEntry,
                                           logicalCoordinate))
    {
        cout << subdivisionEntry->getName() << endl;
    }
    else
    {
        cout << "none" << endl;
        return 1;
    }

    return 0;
}
